/*
 * -----------------------------------------------------------------------------
 * Tagged Stream Format V1.1.19
 * Copyright (c) 2017-2019 Rudy Tellert Elektronik
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to deal 
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 * SOFTWARE.
 * -----------------------------------------------------------------------------
 */

#include "tsf_priv.h"

#ifdef TSF_SUPPORT_WIN32

#include <Windows.h>

#ifdef TSF_SUPPORT_UUID

static TsfUInt32 GetUnixTime(void)
{
    SYSTEMTIME st;
    FILETIME ft;
    memset(&st, '\0', sizeof(st));
    GetSystemTime(&st);
    SystemTimeToFileTime(&st, &ft);
    return (TsfUInt32)(((*(TsfUInt64*)&ft) - 0x019db1ded53e8000i64) / 10000000);
}

static void TsfUuidFromTime(TsfUuid uuid)
{
    if (uuid) {
        TsfUInt64 nonce;
        
        /* The next line can be commented out if the nonce is limited to this platform's byte order */
        TsfAssert(TsfIsLittleEndian());

        ((TsfUInt32*)&nonce)[1] = GetUnixTime();
        ((TsfUInt32*)&nonce)[0] = GetTickCount();
        TsfUuidFromNonce(uuid, nonce);
    }
}

void TSF_API TsfUuidNew(TsfUuid uuid)
{
    Sleep(2); /* forcible delay so that GetTickCount() always returns a different value */

    TsfUuidFromTime(uuid);
}

#endif

#endif
