/*
 * -----------------------------------------------------------------------------
 * Tagged Stream Format V1.1.19
 * Copyright (c) 2017-2019 Rudy Tellert Elektronik
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to deal 
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 * SOFTWARE.
 * -----------------------------------------------------------------------------
 */

#ifndef __TSF_PRIV_H
#define __TSF_PRIV_H

#include "tsf.h"
#include <assert.h>
#include <stdio.h>

#ifdef TSF_USE_EXTERN_C
extern "C" {
#endif

    /* internal */
    TSF_EXPORT void TSF_API TsfInit(TsfObject *tsf); /* used by TsfOpen and TsfCreate */
    TSF_EXPORT void TSF_API TsfReverse(void *data, size_t size);

#ifdef TSF_USE_EXTERN_C
}
#endif

#ifdef TSF_DEBUG
#  define TsfAssert(cond) assert(cond)
#else
#  define TsfAssert(cond)
#endif

#define TSF_START_PATTERN 0xe071bb5b
#define TSF_END_PATTERN   0xbc607d97
#define TsfStdAssert(tsf) \
  TsfAssert(tsf); \
  TsfAssert(tsf->StartPattern == TSF_START_PATTERN); \
  TsfAssert(tsf->EndPattern == TSF_END_PATTERN)

#define TSF_HEADER0     '\x01'
#define TSF_HEADER1     '\xe1'
#define TSF_HEADER2     0x7374
#define TSF_HEADER2_REV 0x7473

#endif
