/*
 * -----------------------------------------------------------------------------
 * Tagged Stream Format V1.1.19
 * Copyright (c) 2017-2019 Rudy Tellert Elektronik
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to deal 
 * in the Software without restriction, including without limitation the rights 
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 * SOFTWARE.
 * -----------------------------------------------------------------------------
 */

#include "tsf_priv.h"

/*- internal -----------------------------------------------------------------*/

void TSF_API TsfInit(TsfObject *tsf)
{
    TsfAssert(tsf);
    TsfAssert(tsf->StartPattern != TSF_START_PATTERN);
    TsfAssert(tsf->EndPattern != TSF_END_PATTERN);

    memset(tsf, '\0', sizeof(TsfObject));

#ifdef TSF_DEBUG
    tsf->StartPattern = TSF_START_PATTERN;
    tsf->EndPattern = TSF_END_PATTERN;
#endif
}

#ifdef TSF_SUPPORT_REV
void TSF_API TsfReverse(void *data, size_t size)
{
    char *p;
    size_t i;

    TsfAssert(data);

    p = (char *)data;

    if (size == 0) return;
#define last size
    last--;

    for (i = 0;; i++, last--) {
        char ch;
        if (i >= last) return;
        ch = p[i];
        p[i] = p[last];
        p[last] = ch;
    }
#undef last
}
#endif

/*- Reverse Access -----------------------------------------------------------*/

#ifdef TSF_SUPPORT_REV_ACCESS
TsfBool TSF_API TsfGetReverse(TsfObject *tsf)
{
    TsfStdAssert(tsf);

    return (tsf->Header == TSFH_REV);
}

void TSF_API TsfSetReverse(TsfObject *tsf, TsfBool isRev)
{
    TsfStdAssert(tsf);

    tsf->Header = isRev ? TSFH_REV : TSFH_NORMAL;
#ifdef TSF_SUPPORT_REV_FIELD
    tsf->Reverse = isRev ? TSF_TRUE : TSF_FALSE;
#endif
}
#endif

/*- IsLittleEndian -----------------------------------------------------------*/

#ifdef TSF_SUPPORT_REV_CHECK
TsfBool TSF_API TsfIsLittleEndian(void)
{
    TsfUInt16 tmp = 0xff;
    return (*((const TsfByte *)&tmp) != 0) ? TSF_TRUE : TSF_FALSE;
}
#endif

/*- close --------------------------------------------------------------------*/

#ifdef TSF_DEBUG
void TSF_API TsfClose(TsfObject *tsf)
{
    TsfStdAssert(tsf);

    tsf->StartPattern = ~TSF_START_PATTERN;
    tsf->EndPattern = ~TSF_END_PATTERN;
}
#endif
