/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Excerpt from Tagged Stream Format V1.1.16                                  */
/*----------------------------------------------------------------------------*/

#ifndef __TSF_PRIV_H
#define __TSF_PRIV_H

#include "bootldr.h"

#ifdef TSF_USE_EXTERN_C
extern "C" {
#endif

    /* internal */
    TSF_EXPORT void TSF_API TsfInit(TsfObject *tsf); /* used by TsfOpen and TsfCreate */
    TSF_EXPORT void TSF_API TsfReverse(void *data, size_t size);

#ifdef TSF_USE_EXTERN_C
}
#endif

#define TsfAssert(cond)
#define TsfStdAssert(tsf)

#define TSF_HEADER0     '\x01'
#define TSF_HEADER1     '\xe1'
#define TSF_HEADER2     0x7374
#define TSF_HEADER2_REV 0x7473

#endif
