/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __QUEUE_H
#define __QUEUE_H

typedef struct {
    volatile Byte *Read;
    volatile Byte *Write;
    Byte *Begin;
    Byte *Last;
    size_t Size;
    size_t SizeMinusOne;
} Queue;

void QueueInit(Queue *q, void *buffer, size_t size);
Bool QueuePut(Queue *q, Byte b);
Bool QueueGet(Queue *q, Byte *p);
void QueueFlush(Queue *q);
size_t QueueGetUsed(Queue *q);
size_t QueueGetFree(Queue *q);
Bool QueueIsFull(Queue *q);
Bool QueueIsEmpty(Queue *q);

#endif
