/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __MAP_H
#define __MAP_H

#include "pack.h"

typedef struct {
    UInt Address;
    UInt Length;
} erase_item_t;

typedef struct {
    UInt Address;
    Byte *DataItems; size_t DataCount;
} memory_item_t;

#ifndef USE_TINY_BOOTLOADER

typedef struct {
    UInt Type;
    UInt Min;
    UInt Max;
    UInt XorMask;
    UInt ReqFeatures;
} drm_item_t;

typedef struct {
    drm_item_t *DrmItems; size_t DrmCount;
    erase_item_t *EraseItems; size_t EraseCount;
    memory_item_t *MemoryItems; size_t MemoryCount;
    Byte EraseRegions;
    Byte LastBlock;
    Byte Reserved[2];
} map_t;

#else

typedef struct {
    UInt Type;
    UInt MinOrXorMask;
    UInt MaxOrReqFeatures;
} drm_item_t;

#define DRM_SIGNATURE 0xf8139cbd
#define DRM_REV_SIGNATURE 0xbd9c13f8

typedef struct {
    UInt DrmSignature;
    UInt EraseRegions;
    UInt Count;
    drm_item_t Items[1];
} drm_t;

#define MAP_DATA_SIZE 0x100
typedef struct {
    UInt Address;
    UInt Count;
    Byte Data[MAP_DATA_SIZE];
} data_t;

typedef struct {
    Byte EraseCount;
    Byte MemoryCount;
    Byte EraseRegions;
    Byte LastBlock;
    erase_item_t *EraseItems;
    memory_item_t *MemoryItems;
    memory_item_t MemoryItem;
    Byte Data[MAP_DATA_SIZE];
} map_t;

#endif

#include "unpack.h"

Bool GetMap(const void *data, size_t dataSize, void *mapData, size_t mapSize, Bool unobfuscated,
    const application_info_t *appInfo, unsigned blockNumber);

#endif