﻿/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

using System;
using System.IO;
using System.IO.Ports;
using Tellert.Bootloader;

namespace appldrc
{
    class Program
    {
        static int Main(string[] args)
        {
            int t0 = 0;
            int t1 = 0;
            bool result = true;
            Firmware fw = new Firmware();
            if (!fw.Read((args.Length > 0) ? args[0] : "device.tsf"))
            {
                if (fw.IsChecksumMismatch)
                {
                    Console.WriteLine("ERROR: Corrupt firmware file!");
                }
                else
                {
                    Console.WriteLine("ERROR: Incompatible file!");
                }
                return 1;
            }
            string port = (args.Length > 1) ? args[1] : "COM1";
            Console.WriteLine("Power on device at {0}...", port);
            string[] ports = SerialPort.GetPortNames();
            Bootloader bl = new Bootloader();
            bl.Init(port);
            while (bl.IsInit && !Console.KeyAvailable) ;
            //if (Console.KeyAvailable) Console.ReadKey(true);
            bl.ReadVersion();
            int br = bl.GetMaxBaudRate();
            bl.ChangeBaudRate(br);
            bl.ReadInfo();
            if (!fw.IsCompatible())
            {
                Console.WriteLine("ERROR: Device is incompatible!");
                return 1;
            }
            bl.UpdateAppInfo();
            int i;
            byte[][] core = fw.GetCoreBlocks();
            byte[][][] config = fw.GetConfigBlocks();
            int n = Firmware.GetBlockCount(core, config);
            int m = 1;
            for (i = 0; i < core.Length; i++)
            {
                Console.Write("\rProgress: {0} %     ", (m * 100) / n);
                if (!bl.WriteBlockCommand(Bootloader.Command.WriteObfuscatedBlock, core[i], 0, core[i].Length, i, t0, t1))
                {
                    result = false;
                    break;
                }
                m++;
            }
            if (result)
            {
                for (i = 0; i < config.Length; i++)
                {
                    bl.NewBlockSequence();
                    for (int k = 0; k < config[i].Length; k++)
                    {
                        Console.Write("\rProgress: {0} %     ", (m * 100) / n);
                        if (!bl.WriteBlockCommand(Bootloader.Command.WriteNonObfuscatedBlock, config[i][k], 0, config[i][k].Length, k, t0, t1))
                        {
                            result = false;
                            break;
                        }
                        m++;
                    }
                    if (result == false) break;
                }
            }
            Console.WriteLine(result ? "" : "\nError!");
            bl.RunApp();
            bl.Exit();
            return result ? 0 : 1;
        }
    }
}
