#ifndef __TIL_H
#define __TIL_H

#include <limits.h>
#include <float.h>
#include <stdlib.h>

/*==============================================================================
// TEMES Import Library V1.3.3
// Copyright (c) 2001-2011 Tellert Elektronik GmbH
// Copyright (c) 2014-2018 Rudy Tellert Elektronik
//============================================================================*/

#ifndef TIL_EXPORT
  #define TIL_EXPORT __declspec(dllimport)
#endif
#define TIL_API __stdcall

#if defined(UNICODE) || defined(_UNICODE)
  #define TIL_UNICODE
#endif

#ifdef __cplusplus
  #define TIL_USE_EXTERN_C
  #define TIL_USE_INLINE
#endif

#if INT_MAX == 0x7fi8
  #define TIL_INT_BIT 8
#elif INT_MAX == 0x7fffi16
  #define TIL_INT_BIT 16
#elif INT_MAX == 0x7fffffffi32
  #define TIL_INT_BIT 32
#elif INT_MAX == 0x7fffffffffffffffi64
  #define TIL_INT_BIT 64
#else
  #define TIL_INT_BIT 0
#endif

#if UINT_MAX == 0xffui8
  #define TIL_UINT_BIT 8
#elif UINT_MAX == 0xffffui16
  #define TIL_UINT_BIT 16
#elif UINT_MAX == 0xffffffffui32
  #define TIL_UINT_BIT 32
#elif UINT_MAX == 0xffffffffffffffffui64
  #define TIL_UINT_BIT 64
#else
  #define TIL_UINT_BIT 0
#endif

#ifndef SIZE_MAX
  #define SIZE_MAX UINT_MAX
#endif

#if SIZE_MAX == 0xffui8
  #define TIL_SIZET_BIT 8
#elif SIZE_MAX == 0xffffui16
  #define TIL_SIZET_BIT 16
#elif SIZE_MAX == 0xffffffffui32
  #define TIL_SIZET_BIT 32
#elif SIZE_MAX == 0xffffffffffffffffui64
  #define TIL_SIZET_BIT 64
#else
  #define TIL_SIZET_BIT 0
#endif

#if LDBL_MAX_EXP == 16384
  #define TIL_USE_FLOAT80
#endif

/*------------------------------------------------------------------------------
// Tellert Import Library Interface
//----------------------------------------------------------------------------*/

#define TIL_PTYPE(type, def) \
  typedef def *TIL_P##type; \
  typedef def *TIL_LP##type;        /* support for WIN32 naming convention */ \
  typedef def const *TIL_PC##type; \
  typedef def const *TIL_LPC##type; /* support for WIN32 naming convention */ \
  typedef def const *TIL_CP##type;  /* legacy support for V1.1.1 downwards */

#define TIL_TYPE(type, def) \
  typedef def TIL_##type; \
  TIL_PTYPE(type, def)

TIL_PTYPE(OBJECT, void);
TIL_PTYPE(PROP, void);
TIL_PTYPE(DATA, void);
TIL_TYPE(CHAR, char);
TIL_PTYPE(STR, char);
TIL_TYPE(WCHAR, wchar_t);
TIL_PTYPE(WSTR, wchar_t);
TIL_TYPE(PROPID, int);
TIL_TYPE(TYPEID, int);
TIL_TYPE(DATASIZE, size_t);
TIL_TYPE(STRLEN, size_t);
TIL_TYPE(BOOL, int);
TIL_TYPE(INT8, __int8);
TIL_TYPE(INT16, __int16);
TIL_TYPE(INT32, __int32);
TIL_TYPE(INT64, __int64);
TIL_TYPE(UINT8, unsigned __int8);
TIL_TYPE(UINT16, unsigned __int16);
TIL_TYPE(UINT32, unsigned __int32);
TIL_TYPE(UINT64, unsigned __int64);
TIL_TYPE(FLOAT32, float);
TIL_TYPE(FLOAT64, double);
TIL_TYPE(TIME64, double);
#ifdef TIL_USE_FLOAT80
  typedef long double TIL_LDBL;
#else
  #pragma pack(push,1)
  typedef struct s_TIL_LDBL {
    TIL_UINT64 mantissa;
    TIL_UINT16 exponent:15;
    TIL_UINT16 sign:1;
  } TIL_LDBL;
  #pragma pack(pop)
#endif
TIL_TYPE(FLOAT80, TIL_LDBL);
#pragma pack(push,1)
typedef struct s_TIL_DT {
    TIL_UINT32 usec;
    TIL_UINT16 sec;
    TIL_UINT16 min;
    TIL_UINT16 hour;
    TIL_UINT16 day;
    TIL_UINT16 month;
    TIL_UINT16 year;
} TIL_DT;
#pragma pack(pop)
TIL_TYPE(DATETIME, TIL_DT);

/* property type ID */
#define TILID_VOID 0
#define TILID_BOOL 1
#define TILID_INT8 2
#define TILID_INT16 3
#define TILID_INT32 4
#define TILID_INT64 5
#define TILID_UINT8 8
#define TILID_UINT16 9
#define TILID_UINT32 10
#define TILID_UINT64 11
#define TILID_FLOAT32 32
#define TILID_FLOAT64 33
#define TILID_FLOAT80 34
#define TILID_TIME64 40
#define TILID_DATA 64
#define TILID_STR 65
#define TILID_WSTR 66
#define TILID_COLLECTION 128
#define TILID_VECTOR 129
#define TILID_ITERATOR 130

/* property IDs */
#define tilLocal 1
  #define tilLocalLangID 1
  #define tilLocalResolvedLangID 2
  #define tilLocalSupportedLangIDs 3

#define tilInfo 2
  #define tilInfoSupportedTypes 1
    #define tilInfoSupportedTypesGUID 1
    #define tilInfoSupportedTypesDescription 2
    #define tilInfoSupportedTypesExtension 3
    #define tilInfoSupportedTypesArgGUIDs 4
    #define tilInfoSupportedTypesFeatures 5
      #define tilInfoSupportedTypesFeaturesGUID 1
      #define tilInfoSupportedTypesFeaturesData 2
    #define tilInfoVersion 2

#define tilControl 3
  #define tilControlTypeIndex 1
  #define tilControlArgs 2
    #define tilControlArgsGUID 1
    #define tilControlArgsData 2
  #define tilControlFileName 3

#define tilData 4

#ifdef TIL_USE_EXTERN_C
extern "C" {
#endif

TIL_EXPORT TIL_POBJECT  TIL_API TilCreateObjectA(TIL_PCSTR pObjectGUID);
TIL_EXPORT TIL_POBJECT  TIL_API TilCreateObjectW(TIL_PCWSTR pObjectGUID);
TIL_EXPORT void         TIL_API TilDestroyObject(TIL_POBJECT pObject);

TIL_EXPORT TIL_PPROP    TIL_API TilGetRootProperty(TIL_POBJECT pObject);

TIL_EXPORT TIL_TYPEID   TIL_API TilGetType(TIL_PCPROP pProp);
TIL_EXPORT TIL_BOOL     TIL_API TilGetBool(TIL_PCPROP pProperty, TIL_PBOOL pBool);
TIL_EXPORT TIL_BOOL     TIL_API TilGetInt8(TIL_PCPROP pProperty, TIL_PINT8 pInt8);
TIL_EXPORT TIL_BOOL     TIL_API TilGetInt16(TIL_PCPROP pProperty, TIL_PINT16 pInt16);
TIL_EXPORT TIL_BOOL     TIL_API TilGetInt32(TIL_PCPROP pProperty, TIL_PINT32 pInt32);
TIL_EXPORT TIL_BOOL     TIL_API TilGetInt64(TIL_PCPROP pProperty, TIL_PINT64 pInt64);
TIL_EXPORT TIL_BOOL     TIL_API TilGetUInt8(TIL_PCPROP pProperty, TIL_PUINT8 pUInt8);
TIL_EXPORT TIL_BOOL     TIL_API TilGetUInt16(TIL_PCPROP pProperty, TIL_PUINT16 pUInt16);
TIL_EXPORT TIL_BOOL     TIL_API TilGetUInt32(TIL_PCPROP pProperty, TIL_PUINT32 pUInt32);
TIL_EXPORT TIL_BOOL     TIL_API TilGetUInt64(TIL_PCPROP pProperty, TIL_PUINT64 pUInt64);
TIL_EXPORT TIL_BOOL     TIL_API TilGetFloat32(TIL_PCPROP pProperty, TIL_PFLOAT32 pFloat32);
TIL_EXPORT TIL_BOOL     TIL_API TilGetFloat64(TIL_PCPROP pProperty, TIL_PFLOAT64 pFloat64);
TIL_EXPORT TIL_BOOL     TIL_API TilGetFloat80(TIL_PCPROP pProperty, TIL_PFLOAT80 pFloat80);
TIL_EXPORT TIL_BOOL     TIL_API TilGetTime64(TIL_PCPROP pProperty, TIL_PTIME64 pTime64);
TIL_EXPORT TIL_BOOL     TIL_API TilSetBool(TIL_PPROP pProperty, TIL_BOOL Bool);
TIL_EXPORT TIL_BOOL     TIL_API TilSetInt8(TIL_PPROP pProperty, TIL_INT8 Int8);
TIL_EXPORT TIL_BOOL     TIL_API TilSetInt16(TIL_PPROP pProperty, TIL_INT16 Int16);
TIL_EXPORT TIL_BOOL     TIL_API TilSetInt32(TIL_PPROP pProperty, TIL_INT32 Int32);
TIL_EXPORT TIL_BOOL     TIL_API TilSetInt64(TIL_PPROP pProperty, TIL_INT64 Int64);
TIL_EXPORT TIL_BOOL     TIL_API TilSetUInt8(TIL_PPROP pProperty, TIL_INT8 UInt8);
TIL_EXPORT TIL_BOOL     TIL_API TilSetUInt16(TIL_PPROP pProperty, TIL_UINT16 UInt16);
TIL_EXPORT TIL_BOOL     TIL_API TilSetUInt32(TIL_PPROP pProperty, TIL_UINT32 UInt32);
TIL_EXPORT TIL_BOOL     TIL_API TilSetUInt64(TIL_PPROP pProperty, TIL_UINT64 UInt64);
TIL_EXPORT TIL_BOOL     TIL_API TilSetFloat32(TIL_PPROP pProperty, TIL_FLOAT32 Float32);
TIL_EXPORT TIL_BOOL     TIL_API TilSetFloat64(TIL_PPROP pProperty, TIL_FLOAT64 Float64);
TIL_EXPORT TIL_BOOL     TIL_API TilSetFloat80(TIL_PPROP pProperty, TIL_FLOAT80 Float80);
TIL_EXPORT TIL_BOOL     TIL_API TilSetTime64(TIL_PPROP pProperty, TIL_TIME64 Time64);

TIL_EXPORT TIL_PPROP    TIL_API TilGetProperty(TIL_PPROP pProp, TIL_PROPID PropID);
TIL_EXPORT TIL_PPROP    TIL_API TilGetPropertyEx(TIL_PPROP pProp, TIL_PROPID PropID, TIL_PTYPEID pTypeID);

TIL_EXPORT TIL_DATASIZE TIL_API TilGetVectorSize(TIL_PCPROP pVector);
TIL_EXPORT TIL_PPROP    TIL_API TilGetVectorItem(TIL_PCPROP pVector, TIL_DATASIZE Position);
TIL_EXPORT TIL_PPROP    TIL_API TilGetVectorItemEx(TIL_PCPROP pVector, TIL_DATASIZE Position, TIL_PTYPEID pTypeID);
TIL_EXPORT TIL_BOOL     TIL_API TilResizeVector(TIL_PPROP pVector, TIL_DATASIZE NewSize);

TIL_EXPORT TIL_DATASIZE TIL_API TilGetIteratorItemSize(TIL_PCPROP pIterator);
TIL_EXPORT TIL_DATASIZE TIL_API TilGetIteratorItemCount(TIL_PCPROP pIterator);
TIL_EXPORT TIL_BOOL     TIL_API TilRewindIterator(TIL_PPROP pIterator);
TIL_EXPORT TIL_BOOL     TIL_API TilGetNextIteratorItems(TIL_PPROP pIterator, void *pDest, TIL_DATASIZE nCount);

TIL_EXPORT TIL_STRLEN   TIL_API TilGetStringLength(TIL_PPROP pStrProp);
TIL_EXPORT TIL_BOOL     TIL_API TilGetStringA(TIL_PPROP pStrProp, TIL_PSTR pStr, TIL_STRLEN MaxStringLen, TIL_PSTRLEN StringLen);
TIL_EXPORT TIL_BOOL     TIL_API TilGetStringW(TIL_PPROP pStrProp, TIL_PWSTR pStr, TIL_STRLEN MaxStringLen, TIL_PSTRLEN StringLen);
TIL_EXPORT TIL_BOOL     TIL_API TilSetStringA(TIL_PPROP pStrProp, TIL_PCSTR pStr);
TIL_EXPORT TIL_BOOL     TIL_API TilSetStringW(TIL_PPROP pStrProp, TIL_PCWSTR pStr);
TIL_EXPORT TIL_BOOL     TIL_API TilSetStringExA(TIL_PPROP pStrProp, TIL_PCSTR pStr, TIL_STRLEN StrLen);
TIL_EXPORT TIL_BOOL     TIL_API TilSetStringExW(TIL_PPROP pStrProp, TIL_PCWSTR pStr, TIL_STRLEN StrLen);

TIL_EXPORT TIL_DATASIZE TIL_API TilGetDataSize(TIL_PPROP pDataProp);
TIL_EXPORT TIL_BOOL     TIL_API TilGetData(TIL_PPROP pDataProp, TIL_PDATA pData, TIL_DATASIZE MaxDataSize, TIL_PDATASIZE DataSize);
TIL_EXPORT TIL_BOOL     TIL_API TilSetData(TIL_PPROP pDataProp, TIL_PCDATA pData, TIL_DATASIZE DataSize);

#ifdef TIL_USE_EXTERN_C
};
#endif

#define TilGetMaxStringLength TilGetStringLength
#define TilGetMaxStringBufferCount(pStrProp) (TilGetStringLength(pStrProp) + 1)
#define TIL_QUERY_STRLEN ((TIL_STRLEN)-1)

#define TIL_L(str) L ## str
#ifdef TIL_UNICODE
  #define TIL_T(str) TIL_L(str)
  #define TIL_TEXT(str) TIL_L(str)
  TIL_TYPE(TCHAR, wchar_t);
  TIL_PTYPE(TSTR, wchar_t);
  #define TilCreateObject TilCreateObjectW
  #define TilGetString TilGetStringW
  #define TilSetString TilSetStringW
  #define TilSetStringEx TilSetStringExW
#else
  #define TIL_T(str) str
  #define TIL_TEXT(str) str
  TIL_TYPE(TCHAR, char);
  TIL_PTYPE(TSTR, char);
  #define TilCreateObject TilCreateObjectA
  #define TilGetString TilGetStringA
  #define TilSetString TilSetStringA
  #define TilSetStringEx TilSetStringExA
#endif

#ifdef TIL_USE_INLINE
  /* return buffer count including terminating NUL (count >= 1)  */
  inline TIL_STRLEN TilGetSafeBufferCountA(TIL_PPROP pStr) {
    TIL_STRLEN Len = 0;
    TilGetStringA(pStr, NULL, TIL_QUERY_STRLEN, &Len);
    return Len+1;
  }
  inline TIL_STRLEN TilGetSafeBufferCountW(TIL_PPROP pStr) {
    TIL_STRLEN Len = 0;
    TilGetStringW(pStr, NULL, TIL_QUERY_STRLEN, &Len);
    return Len+1;
  }
  /* return buffer count including terminating NUL, or 0 if pStr is invalid (count >= 0) */
  inline TIL_STRLEN TilGetBufferCountA(TIL_PPROP pStr) {
    TIL_STRLEN Len = (TIL_STRLEN)-1;
    TilGetStringA(pStr, NULL, TIL_QUERY_STRLEN, &Len);
    return Len+1;
  }
  inline TIL_STRLEN TilGetBufferCountW(TIL_PPROP pStr) {
    TIL_STRLEN Len = (TIL_STRLEN)-1;
    TilGetStringW(pStr, NULL, TIL_QUERY_STRLEN, &Len);
    return Len+1;
  }
  #ifdef TIL_UNICODE
    #define TilGetSafeBufferCount TilGetSafeBufferCountW
    #define TilGetBufferCount TilGetBufferCountW
  #else
    #define TilGetSafeBufferCount TilGetSafeBufferCountA
    #define TilGetBufferCount TilGetBufferCountA
  #endif
#endif

#define TIL_TRUE  (1==1)
#define TIL_FALSE (0==1)

#if TIL_INT_BIT == 8
  TIL_TYPE(INT, __int8);
  #define TILID_INT TILID_INT8
  #define TilGetInt(prop, p) TilGetInt8(prop, (TIL_PINT8)(p))
  #define TilSetInt TilSetInt8
#elif TIL_INT_BIT == 16
  TIL_TYPE(INT, __int16);
  #define TILID_INT TILID_INT16
#define TilGetInt(prop, p) TilGetInt16(prop, (TIL_PINT16)(p))
  #define TilSetInt TilSetInt16
#elif TIL_INT_BIT == 32
  TIL_TYPE(INT, __int32);
  #define TILID_INT TILID_INT32
#define TilGetInt(prop, p) TilGetInt32(prop, (TIL_PINT32)(p))
  #define TilSetInt TilSetInt32
#elif TIL_INT_BIT == 64
  TIL_TYPE(INT, __int64);
  #define TILID_INT TILID_INT64
#define TilGetInt(prop, p) TilGetInt64(prop, (TIL_PINT64)(p))
  #define TilSetInt TilSetInt64
#endif

#if TIL_UINT_BIT == 8
  TIL_TYPE(UINT, unsigned __int8);
  #define TILID_UINT TILID_UINT8
#define TilGetUInt(prop, p) TilGetUInt8(prop, TIL_PUINT8)(p))
  #define TilSetUInt TilSetUInt8
#elif TIL_UINT_BIT == 16
  TIL_TYPE(UINT, unsigned __int16);
  #define TILID_UINT TILID_UINT16
#define TilGetUInt(prop, p) TilGetUInt16(prop, (TIL_PUINT16)(p))
  #define TilSetUInt TilSetUInt16
#elif TIL_UINT_BIT == 32
  TIL_TYPE(UINT, unsigned __int32);
  #define TILID_UINT TILID_UINT32
#define TilGetUInt(prop, p) TilGetUInt32(prop, (TIL_PUINT32)(p))
  #define TilSetUInt TilSetUInt32
#elif TIL_UINT_BIT == 64
  TIL_TYPE(UINT, unsigned __int64);
  #define TILID_UINT TILID_UINT64
#define TilGetUInt(prop, p) TilGetUInt64(prop, (TIL_PUINT64)(p))
  #define TilSetUInt TilSetUInt64
#endif

#if TIL_SIZET_BIT == 32
  TIL_TYPE(SIZET, unsigned __int32);
  #define TILID_SIZET TILID_UINT32
#define TilGetSizeT(prop, p) TilGetUInt32(prop, (TIL_PUINT32)(p))
  #define TilSetSizeT TilSetUInt32
#elif TIL_SIZET_BIT == 64
  TIL_TYPE(SIZET, unsigned __int64);
  #define TILID_SIZET TILID_UINT64
#define TilGetSizeT(prop, p) TilGetUInt64(prop, (TIL_PUINT64)(p))
  #define TilSetSizeT TilSetUInt64
#endif

/*------------------------------------------------------------------------------
// TEMES Import Library Interface
//----------------------------------------------------------------------------*/

#define TEMES_TIL_GUID_A "{35F0EC67-B7ED-4627-9EF6-563016B176B5}"
#define TEMES_TIL_GUID_W TIL_L(TEMES_TIL_GUID_A)
#define TEMES_TIL_GUID   TIL_T(TEMES_TIL_GUID_A)

/* property type id */
#define tilDataComm 1
  #define tilDataCommName 1
  #define tilDataCommComment 2
  #define tilDataCommVariable 3
    #define tilDataCommVariableKey 1
    #define tilDataCommVariableValue 2

#define tilDataMeas 3
  #define tilDataMeasComm 1
    #define tilDataMeasCommName 1
    #define tilDataMeasCommComment 2
    #define tilDataMeasCommVariable 3
      #define tilDataMeasCommVariableKey 1
      #define tilDataMeasCommVariableValue 2
  #define tilDataMeasGroup 2
    #define tilDataMeasGroupComm 1
      #define tilDataMeasGroupCommName 1
      #define tilDataMeasGroupCommComment 2
      #define tilDataMeasGroupCommVariable 3
        #define tilDataMeasGroupCommVariableKey 1
        #define tilDataMeasGroupCommVariableValue 2
    #define tilDataMeasGroupSampleCount 2
    #define tilDataMeasGroupSampleRate 3
    #define tilDataMeasGroupInfo 4
      #define tilDataMeasGroupInfoTime 1
        #define tilDataMeasGroupInfoTimeHWSetup 1
        #define tilDataMeasGroupInfoTimeStart 2
        #define tilDataMeasGroupInfoTimeHWReadOut 3
        /* start of legacy support for V1.1.1 downwards */
        #define tilDataMeasGroupInfoTimeStamp 4
          #define tilDataMeasGroupInfoTimeStampSampleIndex 1
          #define tilDataMeasGroupInfoTimeStampTime 2
        /* end of legacy support for V1.1.1 downwards */
        #define tilDataMeasGroupInfoTimeSection 4
          #define tilDataMeasGroupInfoTimeSectionSampleIndex 1
          #define tilDataMeasGroupInfoTimeSectionStart 2
    #define tilDataMeasGroupSignal 5
      #define tilDataMeasGroupSignalComm 1
        #define tilDataMeasGroupSignalCommName 1
        #define tilDataMeasGroupSignalCommComment 2
        #define tilDataMeasGroupSignalCommVariable 3
          #define tilDataMeasGroupSignalCommVariableKey 1
          #define tilDataMeasGroupSignalCommVariableValue 2
      #define tilDataMeasGroupSignalInternalName 2
      #define tilDataMeasGroupSignalUnit 3
      #define tilDataMeasGroupSignalData 4
        #define tilDataMeasGroupSignalDataRaw 1
          #define tilDataMeasGroupSignalDataRawType 1
          #define tilDataMeasGroupSignalDataRawFactor 2
          #define tilDataMeasGroupSignalDataRawOffset 3
          #define tilDataMeasGroupSignalDataRawFile 4
            #define tilDataMeasGroupSignalDataRawFileName 1
            #define tilDataMeasGroupSignalDataRawFileOffset 2
            #define tilDataMeasGroupSignalDataRawFileDataSize 3
            #define tilDataMeasGroupSignalDataRawFileGap 4
          #define tilDataMeasGroupSignalDataRawIterator 5
        #define tilDataMeasGroupSignalDataInvalidValue 2
        #define tilDataMeasGroupSignalDataIterator 3
        #define tilDataMeasGroupSignalDataFlags 4
          #define tilDataMeasGroupSignalDataFlagsQuantized 1
          #define tilDataMeasGroupSignalDataFlagsWrapAroundCounter 2
      #define tilDataMeasGroupSignalRefSignal 5
        #define tilDataMeasGroupSignalRefSignalFactor 1
        #define tilDataMeasGroupSignalRefSignalOffset 2
      #define tilDataMeasGroupSignalView 6
        #define tilDataMeasGroupSignalViewMin 1
        #define tilDataMeasGroupSignalViewMax 2
      #define tilDataMeasGroupSignalMarker 7
        #define tilDataMeasGroupSignalMarkerName 1
        #define tilDataMeasGroupSignalMarkerSampleIndex 2
        #define tilDataMeasGroupSignalMarkerVisible 3
        #define tilDataMeasGroupSignalMarkerType 4
        #define tilDataMeasGroupSignalMarkerText 5
        #define tilDataMeasGroupSignalMarkerTextAngle 6
        #define tilDataMeasGroupSignalMarkerTextDistance 7

#define tilDataView 4
  #define tilDataViewComm 1
    #define tilDataViewCommName 1
  #define tilDataViewItem 2
    #define tilDataViewItemComm 1
      #define tilDataViewItemCommName 1
    #define tilDataViewItemSignalInfo 2
      #define tilDataViewItemSignalInfoMeasIndex 1
      #define tilDataViewItemSignalInfoGroupIndex 2
      #define tilDataViewItemSignalInfoSignalIndex 3
    #define tilDataViewItemUnit 3
    #define tilDataViewItemFactor 4
    #define tilDataViewItemOffset 5
    #define tilDataViewItemRefFactor 6
    #define tilDataViewItemRefOffset 7
    #define tilDataViewItemVisible 8
    #define tilDataViewItemSlotVisible 8
	#define tilDataViewItemDigits 9
    #define tilDataViewItemCurveVisible 10
    #define tilDataViewItemColor 11
	#define tilDataViewItemThickness 12
	#define tilDataViewItemPattern 13
    #define tilDataViewItemBegin 14
    #define tilDataViewItemEnd 15
    #define tilDataViewItemAxisPos 16
    #define tilDataViewItemXAxisPos 17
    #define tilDataViewItemAxisMin 18
    #define tilDataViewItemAxisMax 19
    #define tilDataViewItemAxisName 20
    #define tilDataViewItemAxisTitle 21
    #define tilDataViewItemAxisDefMin 22
    #define tilDataViewItemAxisDefMax 23

/* type of signal raw data */
#define dtUnknown 0
#define dtSampleNumber 1
#define dt_u8     2
#define dt_s8     3
#define dt_u16    4
#define dt_s16    5
#define dt_u32    6
#define dt_s32    7
#define dt_u64    8
#define dt_s64    9
#define dt_U8    16
#define dt_S8    17
#define dt_U16   18
#define dt_S16   19
#define dt_U32   20
#define dt_S32   21
#define dt_U64   22
#define dt_S64   23
#define dt_f32   32
#define dt_f64   33
#define dt_f80   34
#define dt_F32   48
#define dt_F64   49
#define dt_F80   50
#define dt_c8    64
#define dt_c16   65
#define dt_t64   80

#endif
