/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __TIMER_H
#define __TIMER_H

typedef UInt timer_t;
#define MSEC_TO_TIMER(x) (x)

void TimerInit(void);
void TimerClose(void);
timer_t TimerGetTickCount(void);

#define BEGIN_TIMER() { timer_t start = TimerGetTickCount(); do {
#define END_TIMER(delay) } while (TimerGetTickCount() - start <= MSEC_TO_TIMER(delay)); }

#endif
