/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#include "bootldr.h"

Bool CompareChecksum(const void *dest, const void *chk, size_t len)
{
    const Byte *pDest = (const Byte *)dest;
    const Byte *pChk = (const Byte *)chk;
    Byte result = 0;

    while (len--) result |= *pDest++ ^ *pChk++;

    return result == 0;
}

UInt GetChecksum32(const void *data, size_t size)
{
    /* See also the compression function of the default hash function */
    UInt state = 1;
    const Byte *p = (const Byte *)data;

    while (size--) {
        state += (state << 8) + (*p++ + 1);
    }

    return state;
}
