/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __BOOTLDR_H
#define __BOOTLDR_H

/*----------------------------------------------------------------------------*/
/* Settings                                                                   */
/*----------------------------------------------------------------------------*/

/* Bootloader */
/* #define USE_TINY_BOOTLOADER */ /* uncomment to obtain a bootloader without using the TSF format */
/* #define REUSE_RAM_AGGRESSIVELY */ /* if defined, the data area is reused (for the tiny bootloader only) */
/* #define REUSE_RX_BUFFER */ /* if defined, rxBuffer is also used for map in order to save RAM */
#define SUPPORT_BIG_ENDIAN /* if defined, big Endian byte order is also supported */
#define SUPPORT_CHECKSUM /* if defined, a checksum for the serial outut is supported */
#define SUPPORT_BAUDRATE_230400
#define SUPPORT_BAUDRATE_115200
#define SUPPORT_BAUDRATE_57600
#define BASE64_SIZE 512 /* max. number of received base64 characters per block */
/* #define USE_ERROR_TEST */ /* if defined, a test release is created with errors for robustness testing */

/* Hash Function */
#define IMPLEMENT_HASH /* comment out, if your own hash function is used */
/* #define USE_HASH_INSTEAD_OF_MAC */ /* uncomment, if the implemented hash function is secure */
/* #define USE_MAC_WITH_PERMUTATION */ /* uncomment, if a 128-bit block permutation is used as a hash function */
#define DOUBLE_HASHING_REQUIRED /* optionally comment out, if the hash function is Keccak */

/* Permutation128 */
#define IMPLEMENT_PERMUTATION128 /* comment out, if obfuscation is NOT used */
#define IMPLEMENT_PERMUTATION128_WITH_HASH /* comment out, if your own PERMUTATION128 is used */

/* Appinfo */
#define PROGRAMMABLE_AREA_BEGIN 0x00000000 /* the programmable area protects the bootloader area */
#define PROGRAMMABLE_AREA_LAST  0xffff7fff 
#define HWINFO_ADDRESS          0xfffffe00
#ifndef _MSC_VER
#define HWINFO_FIXED_ADDRESS /* if defined, the ROM image at HWINFO_ADDRESS is used instead of the default hwInfo */ 
#endif

/* Serial port (WIN32) */
#define COM_NO 4 /* number of the COM port */

/*----------------------------------------------------------------------------*/
/* Declarations and Types                                                     */
/*----------------------------------------------------------------------------*/

#ifdef USE_TINY_BOOTLOADER
#ifdef REUSE_RAM_AGGRESSIVELY
#define REUSE_DATA
#ifdef REUSE_RX_BUFFER
#undef REUSE_RX_BUFFER
#endif
#undef BASE64_SIZE
#define BASE64_SIZE 15 /* small enough to hold the received characters temporarily */
#else
#ifndef REUSE_RX_BUFFER
#define REUSE_RX_BUFFER
#ifdef BASE64_SIZE
#undef BASE64_SIZE
#endif
#define BASE64_SIZE 376 /* can be reduced to 360 in case of HASH_LENGTH <= 8 */
#endif
#endif
#endif

#include <string.h>
#include <stddef.h>
typedef int Bool;
typedef unsigned char Byte;
typedef unsigned short UShort;
typedef unsigned long UInt;
typedef unsigned long long ULong;
#define TRUE  (1==1)
#define FALSE (0==1)
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#define MAX(a,b) (((a) < (b)) ? (b) : (a))
#define zeromem(p, s) memset(p, '\0', s)
#define ASSERT(x)

#ifdef __cplusplus
extern "C" {
#endif

#include "appinfo.h"
#include "checksum.h"
#include "flash.h"
#include "hexstr.h"
#include "map.h"
#include "memblock.h"
#include "obfuscat.h"
#include "primitiv.h"
#include "queue.h"
#include "ser.h"
#include "timer.h"
#include "tsf.h"

#define CHECKSUM_LENGTH 4
#define NONCE_LENGTH 8
#define TAG_LENGTH MIN(HASH_LENGTH / 2, 16)

/* bootldr.c */
#define CREATE_NEW_SESSION 'a'
#define GET_BOOTLOADER_INFO 'b'
#define GET_HARDWARE_INFO 'c'
#define GET_APP_NAME 'd'
#define GET_APP_INFO 'f'
#define GET_CONFIG_INFO 'g'
#define GET_DATA_INFO 'h'
#define PREPARE_BLOCK_MODE_FOR_COMPARISON 'i'
#define PREPARE_BLOCK_MODE_FOR_WRITE 'j'
#define COMPARE_OBFUSCATED_BLOCK 'k'
#define WRITE_OBFUSCATED_BLOCK 'l'
#define COMPARE_NON_OBFUSCATED_BLOCK 'm'
#define WRITE_NON_OBFUSCATED_BLOCK 'n'
#define GET_BLOCK_COUNTER 'o'
#define CHANGE_BAUDRATE 'q'
#define PREPARE_BAUDRATE_9600 's'
#define PREPARE_BAUDRATE_57600 't'
#define PREPARE_BAUDRATE_115200 'u'
#define PREPARE_BAUDRATE_230400 'v'
#define UPDATE_APP_INFO 'x'
#define RUN_APP 'y'
#define PREPARE_TO_RUN_APP 'z'

#define ERR_PREPARE_COMPARISON_MISSING 1
#define ERR_PREPARE_WRITE_MISSING 2
#define ERR_BUFFER_TOO_SMALL 3
#define ERR_CHECKSUM 4
#define ERR_MAP 5
#define ERR_OBFUSCATED_MAP 6
#define ERR_FLASH 7
#define ERR_BAUDRATE 8
#define ERR_PREPARE_RUN_MISSING 9
#define ERR_INVALID_CHAR 10
#define ERR_INVALID_BLOCK_COUNTER 11
#define ERR_TEST 12

#define MAP_UNOBFUSCATED FALSE
#define MAP_OBFUSCATED TRUE

#define ERASE_REGIONS_ALL 1
#define ERASE_REGIONS_APP 2
#define ERASE_REGIONS_DATA 4
#define ERASE_REGIONS_CFG 8
#define ERASE_REGIONS_CFG_DATA 16

#ifdef __cplusplus
}
#endif

#endif
