/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#include "bootldr.h"

#define INC(q, p) (((p)==(q)->Last) ? (q)->Begin : (p)+1)

void QueueInit(Queue *q, void *buffer, size_t size)
{
    q->Read = q->Write = q->Begin = (Byte*)buffer;
    q->Last = ((Byte*)buffer) + size - 1;
    q->Size = size;
    q->SizeMinusOne = size - 1;
}

Bool QueuePut(Queue *q, Byte b)
{
    volatile Byte *nextWrite = INC(q, q->Write);

    if (nextWrite == q->Read) {
        /* Queue is full */
        return FALSE;
    }

    *q->Write = b;
    q->Write = nextWrite;

    return TRUE;
}

Bool QueueGet(Queue *q, Byte *p)
{
    if (q->Read == q->Write) {
        /* Queue is empty */
        return FALSE;
    }

    *p = *q->Read;
    q->Read = INC(q, q->Read);

    return TRUE;
}

void QueueFlush(Queue *q)
{
    q->Read = q->Write;
}

size_t QueueGetUsed(Queue *q)
{
    Byte *r = (Byte*)q->Read;
    Byte *w = (Byte*)q->Write;
    return ((w >= r) ? w - r : q->Size - (r - w));
}

size_t QueueGetFree(Queue *q)
{
    Byte *r = (Byte*)q->Read;
    Byte *w = (Byte*)q->Write;
    return ((r > w) ? r - w - 1 : q->SizeMinusOne - (w - r));
}

Bool QueueIsFull(Queue *q)
{
    return INC(q, q->Write) == q->Read;
}

Bool QueueIsEmpty(Queue *q)
{
    return q->Read == q->Write;
}