/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __PRIMITIV_H
#define __PRIMITIV_H

/*----------------------------------------------------------------------------*/
/* 128-bit Block Permutation                                                  */
/*----------------------------------------------------------------------------*/

#ifdef IMPLEMENT_PERMUTATION128

#ifdef IMPLEMENT_PERMUTATION128_WITH_HASH
#define PERMUTATION128_BLOCK_SIZE HASH_SIZE
typedef struct {
    MacArgs Args;
    Byte Key[7]; /* maximal key size = 7 bytes = 56 bits */
} Permutation128;
#define InitPermutation128KeySchedule()
#else
#define PERMUTATION128_BLOCK_SIZE 128
typedef struct {
    /* [insert code here] */
    Byte dummy;
} Permutation128;
void InitPermutation128KeySchedule(void);
#endif

Bool InitPermutation128(Permutation128 *p, const Byte *key, size_t keySize);
size_t ForwardPermutation128(Permutation128 *p, const Byte *in, size_t inSize, Byte *out, size_t outSize);

#else
typedef Byte Permutation128;
#define InitPermutation128(a,b,c) (1)
size_t ForwardPermutation128(Permutation128 *p, const Byte *in, size_t inSize, Byte *out, size_t outSize);
#define InitPermutation128KeySchedule()
#endif

/*----------------------------------------------------------------------------*/
/* Hash Function                                                              */
/*----------------------------------------------------------------------------*/

#ifdef IMPLEMENT_HASH

#define HASH_SIZE 128
typedef struct {
    ULong State[2];
#ifdef USE_MAC_WITH_PERMUTATION
    size_t Count;
    Permutation128 Permutation;
    Byte Permutation0[(PERMUTATION128_BLOCK_SIZE)/8];
#endif
} Hash;

#ifdef USE_MAC_WITH_PERMUTATION
Bool InitKeyedHash(Hash *, const Byte *key, size_t keySize);
#else
void InitHash(Hash *);
#endif
void UpdateHash(Hash *, const Byte *src, size_t srcSize);
size_t GetHash(Hash *, Byte *dest, size_t destSize);

#else

#define HASH_SIZE 128
typedef struct {
    /* [insert code here] */
    Byte Dummy;
} Hash;

void InitHash(Hash *);
void UpdateHash(Hash *, const Byte *src, size_t srcSize);
size_t GetHash(Hash *, Byte *dest, size_t destSize);

#endif

/*----------------------------------------------------------------------------*/
/* Don't Modify the Following Definitions                                     */
/*----------------------------------------------------------------------------*/

#define HASH_LENGTH ((HASH_SIZE)/8)
#define PERMUTATION128_BLOCK_LENGTH ((PERMUTATION128_BLOCK_SIZE)/8)

#endif
