/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __OBFUSCAT_H
#define __OBFUSCAT_H

typedef struct {
    Byte *Key;
    size_t KeySize;
    Byte *Nonce;
    size_t NonceSize;
    Byte *Msg;
    size_t MsgSize;
    UInt Type;
    UInt DevNo;
} MacArgs;

Bool IsLittleEndian(void);
void ReverseArray(Byte *arr, size_t arrSize);
size_t GetMac(const MacArgs *args, Byte *dest, size_t destSize);
#ifdef USE_HASH_INSTEAD_OF_MAC
size_t GetKeyedHash(const Byte *key, size_t keySize, const Byte *msg, size_t msgSize, Byte *dest, size_t destSize);
#endif
#ifdef IMPLEMENT_PERMUTATION128
#define IMPLEMENT_CTR
Bool GetCtr(const Byte *key, size_t keySize, const Byte *nonce, size_t nonceSize, Byte *msg, size_t msgSize, UInt msgNo);
#else
#define GetCtr(a,b,c,d,e,f,g) (1)
#endif

#endif

