/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __MEMBLOCK_H
#define __MEMBLOCK_H

#include <stddef.h>

typedef struct {
    void *Curr;
    void *Next;
    size_t Avail;
} mem_block_t;

void MemBlockInit(mem_block_t *ctx, void *base, size_t baseSize);
void *MemBlockAlloc(mem_block_t *ctx, size_t itemCount, size_t itemSize);

#endif
