/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#include "bootldr.h"

#ifndef USE_TINY_BOOTLOADER

void MemBlockInit(mem_block_t *ctx, void *base, size_t baseSize)
{
    ctx->Curr = ctx->Next = base;
    ctx->Avail = baseSize;
}

void *MemBlockAlloc(mem_block_t *ctx, size_t itemCount, size_t itemSize)
{
    size_t n = itemSize * itemCount;
    if (ctx->Avail < n) return NULL;
    ctx->Avail -= n;
    ctx->Curr = ctx->Next;
    ctx->Next = ((Byte *)ctx->Next) + n;
    memset(ctx->Curr, '\0', n);
    return ctx->Curr;
}

#endif