/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#include "bootldr.h"

char GetHexDigit(Byte val) 
{
    ASSERT(val < 16);

    return (val < 10) ? ('0' + val) : (('A' - 10) + val);
}

Bool GetHexString(UInt val, char *dest, size_t destSize)
{
    int i;

    if (destSize < 9) return FALSE;

    for (i = 0; i < 8; i++) {
        dest[i] = GetHexDigit( (val >> (28 - (i * 4))) & 0x0f );
    }
    dest[i] = '\0';

    return TRUE;
}
