/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#include "bootldr.h"

#ifdef _MSC_VER
#pragma warning( disable : 4312 )
#endif

#ifndef HWINFO_FIXED_ADDRESS
const hardware_info_t hwInfoConst = {
    0xffff5f00,
    "M00000000 H00000001 F00000000 V00000000 " 
    "D00000000 I00000000 N00000000 C00000000 "
    "T00000000",
    0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    { 0x74, 0x14, 0x54, 0xc6, 0x28, 0x36, 0xff, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0xb7, 0xe0, 0x2d, 0x8a, 0x86, 0x0f, 0x42, 0xef, 
      0x53, 0xac, 0x7d, 0x1f, 0x29, 0x5e, 0x93, 0xc4 }
};

const application_info_t appInfoConst = {
    0xc07b, 
    "DEVICE",
    "A0000 F0000 V00000000 B0000 C0000 D00000000",
    "DEVICE",
    "V0.0",
    0, 0, 0, 0, 0, 0,
    0xffff6000, 0x2000,
    0xffff6000, 0x2000,
    0x00100000, 0x10000,
    0x00100000, 0x10000
};
#endif

const application_info_t *GetAppInfo(void)
{
    if (hwInfoAppInfo->Signature != APP_INFO_SIGNATURE) return NULL;
#ifdef HWINFO_FIXED_ADDRESS
    if (GetChecksum32(&hwInfo.AppInfo, sizeof(application_info_t) - sizeof(UInt)) !=
        hwInfoAppInfo->Checksum) return NULL;
#endif

    return hwInfoAppInfo;
}

const config_info_t *GetConfigInfo(const application_info_t *appInfo)
{
    config_info_t *configInfo;
    if (appInfo == NULL) return NULL;
    if (appInfo->ConfigInfo == 0) return NULL;
    configInfo = (config_info_t*)(appInfo->ConfigInfo);
    if (configInfo->Signature != CONFIG_INFO_SIGNATURE) return NULL;
    if (GetChecksum32(&appInfo->ConfigInfo, sizeof(config_info_t) - sizeof(UInt)) != configInfo->Checksum) return NULL;

    return configInfo;
}

const char *GetDataInfo(const application_info_t *appInfo)
{
    if (appInfo == NULL) return NULL;
    if (appInfo->DataInfo == 0) return NULL;

    return ((data_info_t)(appInfo->DataInfo))();
}

Bool IsAreaProgrammable(const void *addr, size_t size)
{
    size_t p = (size_t)addr;
    if (size == 0) return TRUE;
    if (p < PROGRAMMABLE_AREA_BEGIN) return FALSE;
    if (p + size - 1 > PROGRAMMABLE_AREA_LAST) return FALSE;

    return TRUE;
}
