﻿/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using Tellert.Format;
using Tellert.Bootloader;
using System.IO;
using System.Globalization;

namespace makecfg
{
    [DataContract(Namespace = "http://www.tellert.de/2019/makecfg")]
    public class Config
    {
        [DataMember] public uint idMin, idMax, featuresXorMask, featuresReqMask, versionMin, versionMax, buildMin, buildMax, configMin, configMax;
        [DataMember] public uint manufacturerIdMin, manufacturerIdMax, hardwareIdMin, hardwareIdMax, hardwareVersionMin, hardwareVersionMax;
        [DataMember] public uint manufacturingDateMin, manufacturingDateMax;
        [DataMember] public uint internalDeviceNumberMin, internalDeviceNumberMax, deviceNumberMin, deviceNumberMax, customerIdMin, customerIdMax;
        [DataMember] public uint dateMin, dateMax, hardwareFeaturesXorMask, hardwareFeaturesReq;

        [DataMember] public uint eraseRegions;

        [DataMember] public uint configStart, configDataStart;
    }

    class Program
    {
        public static Config cfg;

        static void AddDrm(List<Firmware.Drm> drmList, uint type, uint min, uint max)
        {
            if (min != 0 || max != 0)
            {
                Firmware.Drm drm = new Firmware.Drm();
                drm.type = type;
                if ((type & 0x40) == 0)
                {
                    drm.min = min;
                    drm.max = max;
                }
                else
                {
                    drm.xorMask = min;
                    drm.reqFeatures = max;
                }
                drmList.Add(drm);
            }
        }

        static Firmware.Drm[] GetDrm()
        {
            List<Firmware.Drm> drmList = new List<Firmware.Drm>();
            AddDrm(drmList, 0, cfg.manufacturerIdMin, cfg.manufacturerIdMax);
            AddDrm(drmList, 1, cfg.hardwareIdMin, cfg.hardwareIdMax);
            AddDrm(drmList, 2, cfg.hardwareVersionMin, cfg.hardwareVersionMax);
            AddDrm(drmList, 3, cfg.internalDeviceNumberMin, cfg.internalDeviceNumberMax);
            AddDrm(drmList, 4, cfg.deviceNumberMin, cfg.deviceNumberMax);
            AddDrm(drmList, 5, cfg.customerIdMin, cfg.customerIdMax);
            AddDrm(drmList, 6, cfg.manufacturingDateMin, cfg.manufacturingDateMax);
            AddDrm(drmList, 64, cfg.hardwareFeaturesXorMask, cfg.hardwareFeaturesReq);
            AddDrm(drmList, 129, cfg.idMin, cfg.idMax);
            AddDrm(drmList, 130, cfg.versionMin, cfg.versionMax);
            AddDrm(drmList, 131, cfg.buildMin, cfg.buildMax);
            AddDrm(drmList, 132, cfg.configMin, cfg.configMax);
            AddDrm(drmList, 133, cfg.dateMin, cfg.dateMax);
            AddDrm(drmList, 192, cfg.featuresXorMask, cfg.featuresReqMask);

            return drmList.ToArray();
        }

        static int Main(string[] args)
        {
            string uri = System.Reflection.Assembly.GetExecutingAssembly().CodeBase;
            string xmlFileName = System.IO.Path.GetFileNameWithoutExtension(new Uri(uri).LocalPath) + ".xml";

            // parse command line
            int offset;
            string dataFileName = null;
            for (offset = 0; offset < args.Length; offset++)
            {
                if (args[offset][0] != '-' && args[offset][0] != '/') break;
                switch (args[offset][1])
                {
                    case 'd':
                        if (offset + 1 < args.Length)
                        {
                            dataFileName = args[++offset];
                        }
                        break;
                    case 'c':
                        if (offset + 2 < args.Length)
                        {
                            offset++;
                            uint size = 0;
                            if (uint.TryParse(args[offset + 1], out size)) {
                                byte[] arr = new byte[size];
                                File.WriteAllBytes(args[offset], arr);
                                return 0;
                            }
                        }
                        break;
                    default:
                        break;
                }
            }

            var ds = new DataContractSerializer(typeof(Config));
            using (Stream s = File.OpenRead(xmlFileName)) cfg = (Config)ds.ReadObject(s);

            int nCmd = args.Length - offset;
            if (nCmd == 1 || nCmd == 2)
            {
                // convert app
                string configFileName = null;
                if (nCmd == 2) {
                    configFileName = args[offset++];
                    nCmd = 1;
                }
                if (configFileName == null && dataFileName == null)
                {
                    return 1;
                }
                int size = 0;
                Firmware fw = new Firmware();
                Firmware.Drm[] drm = GetDrm();
                Firmware.Area[] areas = new Firmware.Area[(configFileName != null && dataFileName != null) ? 2 : 1];
                if (areas.Length == 1)
                {
                    areas[0] = new Firmware.Area();
                    if (configFileName != null)
                    {
                        areas[0].address = cfg.configStart;
                        areas[0].data = File.ReadAllBytes(configFileName);
                    }
                    else {
                        areas[0].address = cfg.configDataStart;
                        areas[0].data = File.ReadAllBytes(dataFileName);
                    }
                    size = areas[0].data.Length;
                }
                else
                {
                    areas[0] = new Firmware.Area();
                    areas[0].address = cfg.configStart;
                    areas[0].data = File.ReadAllBytes(configFileName);
                    areas[1] = new Firmware.Area();
                    areas[1].address = cfg.configDataStart;
                    areas[1].data = File.ReadAllBytes(dataFileName);
                    size = areas[0].data.Length + areas[1].data.Length;
                }
                fw.AddConfig(drm, cfg.eraseRegions, areas);
                fw.core = new Firmware.Core[0];
                fw.Write(args[offset], 0x10000 + size);
            }
            else if (nCmd == 3)
            {
                // merge firmware with config
                Firmware fw = new Firmware();
                fw.Read(args[offset]);
                if (fw.core.Length == 0) {
                    return 1;
                }
                Firmware config = new Firmware();
                config.Read(args[offset + 1]);
                if (config.config.Length == 0)
                {
                    return 1;
                }
                int n = (config.config != null) ? config.config.Length : 0;
                for (int i = 0; i < n; i++)
                {
                    fw.AddConfig(config.config[i].sequence[0].drm,
                        config.config[i].sequence[0].eraseRegions,
                        config.config[i].sequence[0].memoryArea);
                }
                fw.Write(args[offset + 2], fw.fileSize + config.fileSize);
            }

            return 0;
        }
    }
}
