/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* Excerpt from Tagged Stream Format V1.1.16                                  */
/*----------------------------------------------------------------------------*/

#include "tsf_priv.h"

#ifndef USE_TINY_BOOTLOADER

/*- internal -----------------------------------------------------------------*/

void TSF_API TsfInit(TsfObject *tsf)
{
    TsfAssert(tsf);
    TsfAssert(tsf->StartPattern != TSF_START_PATTERN);
    TsfAssert(tsf->EndPattern != TSF_END_PATTERN);

    memset(tsf, '\0', sizeof(TsfObject));
}

#ifdef TSF_SUPPORT_REV
void TSF_API TsfReverse(void *data, size_t size)
{
    char *p;
    size_t i;

    TsfAssert(data);

    p = (char *)data;

    if (size == 0) return;
#define last size
    last--;

    for (i = 0;; i++, last--) {
        char ch;
        if (i >= last) return;
        ch = p[i];
        p[i] = p[last];
        p[last] = ch;
    }
#undef last
}
#endif

/*- Reverse Access -----------------------------------------------------------*/

#ifdef TSF_SUPPORT_REV_ACCESS
TsfBool TSF_API TsfGetReverse(TsfObject *tsf)
{
    TsfStdAssert(tsf);

    return (tsf->Header == TSFH_REV);
}

void TSF_API TsfSetReverse(TsfObject *tsf, TsfBool isRev)
{
    TsfStdAssert(tsf);

    tsf->Header = isRev ? TSFH_REV : TSFH_NORMAL;
#ifdef TSF_SUPPORT_REV_FIELD
    tsf->Reverse = isRev ? TSF_TRUE : TSF_FALSE;
#endif
}
#endif

#endif
