/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __SER_H
#define __SER_H

#ifdef REUSE_RX_BUFFER
extern Byte rxBuffer[(BASE64_SIZE) + 2]; /* made public for buffer reuse */
extern Bool rxBufferLocked;
extern Queue rxQueue;
#endif

Bool SerInit(UInt baudRate);
void SerClose(void);
Bool SerSetBaudrate(UInt baudRate);
Bool SerGet(Byte *p);
Bool SerIsActive(void);
Bool SerPutWithoutChecksum(Byte b);
#ifdef SUPPORT_CHECKSUM
Bool SerPut(Byte b);
#else 
#define SerPut(b) SerPutWithoutChecksum(b)
#endif
Bool SerWrite(const char *);
Bool SerWriteOk(char);
Bool SerWriteOkLine(char, const char *);
Bool SerWriteError(char);
Bool SerWriteErrorLine(char, const char *str);
void SerWaitForTx(void);

#endif
