/*----------------------------------------------------------------------------*/
/* Firmware Obfuscation V1.0.4                                                */
/* Written in 2019 by Rudy Tellert Elektronik                                 */
/*                                                                            */
/* To the extent possible under law, the author has dedicated all copyright   */
/* and related and neighboring rights to the software "firmware obfuscation"  */
/* and its documentation to the public domain. This software and its          */
/* documentation are distributed without any warranty.                        */
/*                                                                            */
/* See also                                                                   */
/* http://creativecommons.org/publicdomain/zero/1.0/                          */
/* ---------------------------------------------------------------------------*/

#ifndef __APPINFO_H
#define __APPINFO_H

#define FEATURE_MASK 0x40

#define HWINFO_MANUFACTURER_ID 0
#define HWINFO_HARDWARE_ID 1
#define HWINFO_HARDWARE_VERSION 2
#define HWINFO_INTERNAL_DEVICE_NUMBER 3
#define HWINFO_DEVICE_NUMBER 4
#define HWINFO_CUSTOMER 5
#define HWINFO_MANUFACTURING_DATE 6
#define HWINFO_HARDWARE_FEATURES 64

#define APPINFO_ID 129
#define APPINFO_VERSION 130
#define APPINFO_BUILD 131
#define APPINFO_CONFIG 132
#define APPINFO_DATE 133
#define APPINFO_FEATURES 192

typedef void(*entry_point_t)();
typedef void(*nmi_isr_t)();
typedef const char *(*data_info_t)();

#include "pack.h"

typedef struct {
    UShort Signature; /* 0xba25 */
    char   Desc[250]; /* may possibly not be '\0'-terminated, string will then be terminated by appInfo.desc */
    UInt   Checksum;
} config_info_t;

typedef struct {
    UShort  Signature; /* 0xc07b */

    /* 118 Bytes '\0' terminated strings */
    char    Desc[64];       /* e.g. "DEVICE STD"                                  */
    char    Info[44];       /* e.g. "Aaaaa Faaaa Vaabbcccc Bbbbb Caaaa Daaaabbbb" */
    /* 48 Bytes '\0' terminated info strings */
    char    Name[21];       /* e.g. DEVICE */
    char    VersionStr[21]; /* e.g. V1.0 */

    /* 4+12 Bytes Application Id/Features/Version/Date */
    UShort  Id;
    UShort  Features;
    UInt    Version; /* AAIIRRRR (A: major - I: minor - R: revision) */
    UShort  Build;
    UShort  Config;
    UInt    Date;

    /* 60 Bytes */
    UInt EraseBegin;   /* erasable configuration area */
    UInt EraseSize;
    UInt ProgramBegin; /* programmable configuration area */
    UInt ProgramSize;
    UInt EraseDataBegin;
    UInt EraseDataSize;
    UInt ProgramDataBegin;
    UInt ProgramDataSize;
    UInt Area1Begin;
    UInt Area1Size;
    UInt Area1Checksum;
    UInt Area2Begin;
    UInt Area2Size;
    UInt Area2Checksum;
    UInt Area3Begin;
    UInt Area3Size;
    UInt Area3Checksum;
    UInt EntryPoint;
    UInt NmiIsr;
    UInt DataInfo;
    UInt ConfigInfo;

    UInt Checksum;
} application_info_t;

typedef struct {
    UInt AppInfo;
    char Info[92]; /* "Maaaabbbb Haaaabbbb Faaaabbbb Vaaaabbbb " */
                   /* "Daaaabbbb Iaaaabbbb Naaaabbbb Caaaabbbb " */
                   /* "Taaaabbbb"                                */
    UInt ManufacturerId;
    UInt HardwareId;
    UInt HardwareFeatures;
    UInt HardwareVersion;
    UInt ManufacturingDate;
    UInt InternalDeviceNumber;
    UInt DeviceNumber;
    UInt Customer;
    UInt DeviceToken;
    UInt Reserved1[4];

    Byte ObfuscationKey[16];
    Byte SigningKey[16];
    Byte ReservedKey1[16];
    Byte ReservedKey2[16];
    Byte RandomBytes1[16];
    Byte RandomBytes2[16];
    Byte Reserved2[12];
} hardware_info_t;

#ifdef HWINFO_FIXED_ADDRESS
#define hwInfo (*(const hardware_info_t *)HWINFO_ADDRESS)
#define hwInfoAppInfo ((application_info_t*)(hwInfo.AppInfo))
#else 
extern const hardware_info_t hwInfoConst;
extern const application_info_t appInfoConst;
#define hwInfo (hwInfoConst)
#define hwInfoAppInfo (&appInfoConst)
#endif

#include "unpack.h"

#define APP_INFO_SIGNATURE ((UShort)0xc07b)
#define CONFIG_INFO_SIGNATURE ((UShort)0xba25)

const application_info_t *GetAppInfo(void);
const config_info_t *GetConfigInfo(const application_info_t *appInfo);
const char *GetDataInfo(const application_info_t *appInfo);
Bool IsAreaProgrammable(const void *addr, size_t size);

#endif
